/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.item.block;

import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.capability.BasketCapabilityProvider;
import azmalent.terraincognita.common.inventory.BasketContainer;
import azmalent.terraincognita.common.inventory.BasketStackHandler;
import azmalent.terraincognita.common.registry.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BasketItem
extends BlockItem {
    public BasketItem(Block block) {
        super(block, new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, playerEntity) -> new BasketContainer(id, inventory, BasketItem.getStackHandler(stack), stack), stack.func_200301_q()));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new BasketCapabilityProvider();
    }

    public static BasketStackHandler getStackHandler(ItemStack basketStack) {
        IItemHandler itemHandler = (IItemHandler)basketStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (itemHandler instanceof BasketStackHandler) {
            return (BasketStackHandler)itemHandler;
        }
        TerraIncognita.LOGGER.error("BasketItem did not have the expected ITEM_HANDLER_CAPABILITY");
        return null;
    }

    public static ItemStack getBasketInHand(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() == ModBlocks.BASKET.getItem()) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() == ModBlocks.BASKET.getItem()) {
            return player.func_184592_cb();
        }
        return null;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT baseTag = stack.func_77978_p();
        BasketStackHandler stackHandler = BasketItem.getStackHandler(stack);
        CompoundNBT capabilityTag = stackHandler.serializeNBT();
        CompoundNBT combinedTag = new CompoundNBT();
        if (baseTag != null) {
            combinedTag.func_218657_a("base", (INBT)baseTag);
        }
        if (capabilityTag != null) {
            combinedTag.func_218657_a("cap", (INBT)capabilityTag);
        }
        return combinedTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT tag) {
        if (tag == null) {
            stack.func_77982_d(null);
            return;
        }
        CompoundNBT baseTag = tag.func_74775_l("base");
        CompoundNBT capabilityTag = tag.func_74775_l("cap");
        stack.func_77982_d(baseTag);
        BasketItem.getStackHandler(stack).deserializeNBT(capabilityTag);
    }
}

